@echo off
setlocal EnableExtensions

set "GPG_EXE=%ProgramFiles%\DirectPay\GnuPG\gpg.exe"
set "GNUPG_HOME=%ProgramData%\DirectPay\GnuPG"
set "KEY_ASC=%ProgramFiles%\DirectPay\Martha Walker.asc"

if not exist "%GPG_EXE%" ( echo ERROR: gpg.exe not found. & exit /b 1 )
if not exist "%KEY_ASC%" ( echo ERROR: Key file not found. & exit /b 1 )
if not exist "%GNUPG_HOME%" mkdir "%GNUPG_HOME%" 2>nul

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --list-keys "mwalker@westpac.com.au" >nul 2>&1
if %errorlevel%==0 ( echo Key already present. & exit /b 0 )

"%GPG_EXE%" --homedir "%GNUPG_HOME%" --import "%KEY_ASC%"
if errorlevel 1 ( echo ERROR: Import failed. & exit /b 1 )

echo Imported Westpac key into shared keyring.
exit /b 0
